/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.text.StrSubstitutor;

public class StringUtils {
    public static String toLowerCase(String str) {
        return str.toLowerCase(Locale.ROOT);
    }

    public static String toUpperCase(String str) {
        return str.toUpperCase(Locale.ROOT);
    }

    public static boolean endsWith(String search, String ... endings) {
        String lowerSearch = StringUtils.toLowerCase(search);
        return Stream.of(endings).anyMatch(lowerSearch::endsWith);
    }

    public static URL toURL(String string) {
        if (string == null || string.trim().isEmpty() || string.contains("myurl.me") || string.contains("example.invalid")) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String parseStringFormat(String input, Map<String, String> properties) {
        return StrSubstitutor.replace((Object)input, properties);
    }

    public static String binToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toHexString((bytes[i] & 0xF0) >> 4));
            sb.append(Integer.toHexString(bytes[i] & 0xF));
        }
        return sb.toString();
    }
}

